/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query;

import com.basho.riak.client.RiakException;
import com.basho.riak.client.operations.RiakOperation;
import com.basho.riak.client.query.LinkPhase;
import com.basho.riak.client.query.MapPhase;
import com.basho.riak.client.query.MapReducePhase;
import com.basho.riak.client.query.MapReduceResult;
import com.basho.riak.client.query.ReducePhase;
import com.basho.riak.client.query.functions.Function;
import com.basho.riak.client.query.serialize.FunctionToJson;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.query.MapReduceSpec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapReduce
implements RiakOperation<MapReduceResult> {
    private final RawClient client;
    private Collection<MapReducePhase> phases = new LinkedList<MapReducePhase>();
    private Long timeout;

    public MapReduce(RawClient client) {
        this.client = client;
    }

    @Override
    public MapReduceResult execute() throws RiakException {
        this.validate();
        String strSpec = this.writeSpec();
        MapReduceSpec spec = new MapReduceSpec(strSpec);
        try {
            return this.client.mapReduce(spec);
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    protected void validate() {
    }

    private String writeSpec() throws RiakException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            JsonGenerator jg = new JsonFactory().createJsonGenerator((OutputStream)out, JsonEncoding.UTF8);
            jg.setCodec((ObjectCodec)new ObjectMapper());
            jg.writeStartObject();
            jg.writeFieldName("inputs");
            this.writeInput(jg);
            jg.writeFieldName("query");
            jg.writeStartArray();
            this.writePhases(jg);
            jg.writeEndArray();
            if (this.timeout != null) {
                jg.writeNumberField("timeout", this.timeout.longValue());
            }
            jg.writeEndObject();
            jg.flush();
            return out.toString("UTF8");
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    private void writePhases(JsonGenerator jg) throws IOException {
        this.writeMapReducePhases(jg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapReducePhases(JsonGenerator jg) throws IOException {
        int cnt = 0;
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            int lastPhase = this.phases.size();
            for (MapReducePhase phase : this.phases) {
                ++cnt;
                jg.writeStartObject();
                jg.writeFieldName(phase.getType().toString());
                jg.writeStartObject();
                switch (phase.getType()) {
                    case MAP: 
                    case REDUCE: {
                        MapPhase mapPhase = (MapPhase)phase;
                        FunctionToJson.newWriter(mapPhase.getPhaseFunction(), jg).write();
                        if (mapPhase.getArg() == null) break;
                        jg.writeObjectField("arg", mapPhase.getArg());
                        break;
                    }
                    case LINK: {
                        jg.writeStringField("bucket", ((LinkPhase)phase).getBucket());
                        jg.writeStringField("tag", ((LinkPhase)phase).getTag());
                    }
                }
                if (cnt == lastPhase) {
                    jg.writeBooleanField("keep", this.isKeepResult(true, phase.isKeep()));
                } else {
                    jg.writeBooleanField("keep", this.isKeepResult(false, phase.isKeep()));
                }
                jg.writeEndObject();
                jg.writeEndObject();
            }
        }
    }

    private boolean isKeepResult(boolean isLastPhase, Boolean phaseKeepValue) {
        if (phaseKeepValue != null) {
            return phaseKeepValue;
        }
        return isLastPhase;
    }

    public MapReduce timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addMapPhase(Function phaseFunction, boolean keep) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new MapPhase(phaseFunction, keep));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addMapPhase(Function phaseFunction, Object arg, boolean keep) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new MapPhase(phaseFunction, arg, keep));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addMapPhase(Function phaseFunction, Object arg) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new MapPhase(phaseFunction, arg));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addMapPhase(Function phaseFunction) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new MapPhase(phaseFunction));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addReducePhase(Function phaseFunction, boolean keep) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new ReducePhase(phaseFunction, keep));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addReducePhase(Function phaseFunction, Object arg, boolean keep) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new ReducePhase(phaseFunction, arg, keep));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addReducePhase(Function phaseFunction, Object arg) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new ReducePhase(phaseFunction, arg));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addReducePhase(Function phaseFunction) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new ReducePhase(phaseFunction));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addLinkPhase(String bucket, String tag, boolean keep) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new LinkPhase(bucket, tag, keep));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapReduce addLinkPhase(String bucket, String tag) {
        Collection<MapReducePhase> collection = this.phases;
        synchronized (collection) {
            this.phases.add(new LinkPhase(bucket, tag));
        }
        return this;
    }

    protected abstract void writeInput(JsonGenerator var1) throws IOException;
}

