/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query;

import com.basho.riak.client.query.MapReduce;
import com.basho.riak.client.query.filter.KeyFilter;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.util.UnmodifiableIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.annotate.JsonProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketMapReduce
extends MapReduce
implements Iterable<KeyFilter> {
    private final String bucket;
    private final Object keyFiltersLock = new Object();
    private final Collection<KeyFilter> keyFilters;

    public BucketMapReduce(RawClient client, String bucket) {
        super(client);
        this.bucket = bucket;
        this.keyFilters = new LinkedList<KeyFilter>();
    }

    public String getBucket() {
        return this.bucket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<KeyFilter> iterator() {
        LinkedList<KeyFilter> copyFilters = new LinkedList<KeyFilter>();
        Object object = this.keyFiltersLock;
        synchronized (object) {
            copyFilters.addAll(this.keyFilters);
        }
        return new UnmodifiableIterator<KeyFilter>(copyFilters.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketMapReduce addKeyFilters(KeyFilter ... keyFilters) {
        List<KeyFilter> filters = Arrays.asList(keyFilters);
        Object object = this.keyFiltersLock;
        synchronized (object) {
            this.keyFilters.addAll(filters);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketMapReduce addKeyFilter(KeyFilter keyFilter) {
        Object object = this.keyFiltersLock;
        synchronized (object) {
            this.keyFilters.add(keyFilter);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasFilters() {
        Object object = this.keyFiltersLock;
        synchronized (object) {
            return !this.keyFilters.isEmpty();
        }
    }

    private Collection<Object[]> getKeyFilters() {
        LinkedList<Object[]> filters = new LinkedList<Object[]>();
        for (KeyFilter filter : this) {
            filters.add(filter.asArray());
        }
        return filters;
    }

    @Override
    protected void writeInput(JsonGenerator jsonGenerator) throws IOException {
        if (this.hasFilters()) {
            jsonGenerator.writeObject(new Object(){
                @JsonProperty
                String bucket;
                @JsonProperty
                Collection<Object[]> key_filters;
                {
                    this.bucket = BucketMapReduce.this.getBucket();
                    this.key_filters = BucketMapReduce.this.getKeyFilters();
                }
            });
        } else {
            jsonGenerator.writeString(this.bucket);
        }
    }
}

