/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.query;

import com.basho.riak.client.query.MapReduce;
import com.basho.riak.client.query.NoInputsException;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.util.UnmodifiableIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.codehaus.jackson.JsonGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketKeyMapReduce
extends MapReduce
implements Iterable<String[]> {
    private final Object inputsLock = new Object();
    private final Collection<String[]> inputs = new LinkedList<String[]>();

    public BucketKeyMapReduce(RawClient client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketKeyMapReduce addInput(String bucket, String key, String keyData) {
        Object object = this.inputsLock;
        synchronized (object) {
            this.inputs.add(new String[]{bucket, key, keyData});
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketKeyMapReduce addInput(String bucket, String key) {
        Object object = this.inputsLock;
        synchronized (object) {
            this.inputs.add(new String[]{bucket, key});
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String[]> iterator() {
        LinkedList<String[]> inputsCopy = new LinkedList<String[]>();
        Object object = this.inputsLock;
        synchronized (object) {
            inputsCopy.addAll(this.inputs);
        }
        return new UnmodifiableIterator<String[]>(inputsCopy.iterator());
    }

    @Override
    protected void writeInput(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeObject((Object)this);
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.inputs.isEmpty()) {
            throw new NoInputsException();
        }
    }
}

