/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.convert.reflect;

import com.basho.riak.client.convert.RiakIndex;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;

public class RiakIndexField {
    private final Field field;
    private final String indexName;
    private final Class type;

    public RiakIndexField(Field field) {
        if (field == null || field.getAnnotation(RiakIndex.class) == null || "".equals(field.getAnnotation(RiakIndex.class).name()) || !field.getType().equals(String.class) && !field.getType().equals(Integer.class) && !field.getType().equals(Integer.TYPE) && !Set.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException(field.getType().toString());
        }
        if (Set.class.isAssignableFrom(field.getType())) {
            Type t = field.getGenericType();
            if (t instanceof ParameterizedType) {
                Class genericType = (Class)((ParameterizedType)t).getActualTypeArguments()[0];
                if (!genericType.equals(String.class) && !genericType.equals(Integer.class)) {
                    throw new IllegalArgumentException(field.getType().toString());
                }
            } else {
                throw new IllegalArgumentException(field.getType().toString());
            }
        }
        this.field = field;
        this.indexName = field.getAnnotation(RiakIndex.class).name();
        this.type = field.getType();
    }

    public Field getField() {
        return this.field;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Class getType() {
        return this.type;
    }
}

