/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.convert.reflect;

import com.basho.riak.client.RiakLink;
import com.basho.riak.client.cap.BasicVClock;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.UsermetaField;
import com.basho.riak.client.convert.reflect.ClassUtil;
import com.basho.riak.client.convert.reflect.RiakIndexField;
import com.basho.riak.client.query.indexes.RiakIndexes;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInfo {
    private static final String NO_RIAK_KEY_FIELD_PRESENT = "no riak key field present";
    private static final String NO_RIAK_VCLOCK_FIELD_PRESENT = "no riak vclock field present";
    private final Field riakKeyField;
    private final List<UsermetaField> usermetaItemFields;
    private final Field usermetaMapField;
    private final List<RiakIndexField> indexFields;
    private final Field riakLinksField;
    private final Field riakVClockField;

    public AnnotationInfo(Field riakKeyField, List<UsermetaField> usermetaItemFields, Field usermetaMapField, List<RiakIndexField> indexFields, Field riakLinksField, Field riakVClockField) {
        this.riakKeyField = riakKeyField;
        this.usermetaItemFields = usermetaItemFields;
        this.validateUsermetaMapField(usermetaMapField);
        this.usermetaMapField = usermetaMapField;
        this.indexFields = indexFields;
        this.validateRiakLinksField(riakLinksField);
        this.riakLinksField = riakLinksField;
        this.riakVClockField = riakVClockField;
    }

    private void validateRiakLinksField(Field riakLinksField) {
        Type[] genericParams;
        if (riakLinksField == null) {
            return;
        }
        ParameterizedType type = (ParameterizedType)riakLinksField.getGenericType();
        if (type.getRawType().equals(Collection.class) && (genericParams = type.getActualTypeArguments()).length == 1 && genericParams[0].equals(RiakLink.class)) {
            return;
        }
        throw new IllegalArgumentException("riak links field must be Collection<RiakLink>");
    }

    private void validateUsermetaMapField(Field usermetaMapField) {
        Type[] genericParams;
        if (usermetaMapField == null) {
            return;
        }
        ParameterizedType type = (ParameterizedType)usermetaMapField.getGenericType();
        if (type.getRawType().equals(Map.class) && (genericParams = type.getActualTypeArguments()).length == 2 && genericParams[0].equals(String.class) && genericParams[1].equals(String.class)) {
            return;
        }
        throw new IllegalArgumentException("user meta map field must be Map<String, String>");
    }

    public boolean hasRiakKey() {
        return this.riakKeyField != null;
    }

    public <T> String getRiakKey(T obj) {
        if (!this.hasRiakKey()) {
            throw new IllegalStateException(NO_RIAK_KEY_FIELD_PRESENT);
        }
        Object key = ClassUtil.getFieldValue(this.riakKeyField, obj);
        return key == null ? null : key.toString();
    }

    public <T> void setRiakKey(T obj, String key) {
        if (!this.hasRiakKey()) {
            throw new IllegalStateException(NO_RIAK_KEY_FIELD_PRESENT);
        }
        ClassUtil.setFieldValue(this.riakKeyField, obj, key);
    }

    public boolean hasRiakVClock() {
        return this.riakVClockField != null;
    }

    public <T> VClock getRiakVClock(T obj) {
        if (!this.hasRiakVClock()) {
            throw new IllegalStateException(NO_RIAK_VCLOCK_FIELD_PRESENT);
        }
        VClock vclock = this.riakVClockField.getType().isAssignableFrom(VClock.class) ? (VClock)ClassUtil.getFieldValue(this.riakVClockField, obj) : new BasicVClock((byte[])ClassUtil.getFieldValue(this.riakVClockField, obj));
        return vclock;
    }

    public <T> void setRiakVClock(T obj, VClock vclock) {
        if (!this.hasRiakVClock()) {
            throw new IllegalStateException(NO_RIAK_VCLOCK_FIELD_PRESENT);
        }
        if (this.riakVClockField.getType().isAssignableFrom(VClock.class)) {
            ClassUtil.setFieldValue(this.riakVClockField, obj, vclock);
        } else {
            ClassUtil.setFieldValue(this.riakVClockField, obj, vclock.getBytes());
        }
    }

    public <T> Map<String, String> getUsermetaData(T obj) {
        LinkedHashMap<String, String> usermetaData = new LinkedHashMap<String, String>();
        Map objectMetaMap = null;
        for (UsermetaField f : this.usermetaItemFields) {
            Object o = ClassUtil.getFieldValue(f.getField(), obj);
            String val = o == null ? null : o.toString();
            String key = f.getUsermetaDataKey();
            if (o == null) continue;
            usermetaData.put(key, val);
        }
        if (this.usermetaMapField != null) {
            objectMetaMap = (Map)ClassUtil.getFieldValue(this.usermetaMapField, obj);
        }
        if (objectMetaMap != null) {
            usermetaData.putAll(objectMetaMap);
        }
        return usermetaData;
    }

    public <T> void setUsermetaData(Map<String, String> usermetaData, T obj) {
        HashMap<String, String> localMetaCopy = new HashMap<String, String>(usermetaData);
        for (UsermetaField f : this.usermetaItemFields) {
            if (!localMetaCopy.containsKey(f.getUsermetaDataKey())) continue;
            ClassUtil.setFieldValue(f.getField(), obj, localMetaCopy.get(f.getUsermetaDataKey()));
            localMetaCopy.remove(f.getUsermetaDataKey());
        }
        if (this.usermetaMapField != null) {
            ClassUtil.setFieldValue(this.usermetaMapField, obj, localMetaCopy);
        }
    }

    public <T> RiakIndexes getIndexes(T obj) {
        RiakIndexes riakIndexes = new RiakIndexes();
        for (RiakIndexField f : this.indexFields) {
            if (Set.class.isAssignableFrom(f.getType())) {
                Type t = f.getField().getGenericType();
                if (!(t instanceof ParameterizedType)) continue;
                Class genericType = (Class)((ParameterizedType)t).getActualTypeArguments()[0];
                if (String.class.equals((Object)genericType)) {
                    riakIndexes.addBinSet(f.getIndexName(), (Set)ClassUtil.getFieldValue(f.getField(), obj));
                    continue;
                }
                if (!Integer.class.equals((Object)genericType)) continue;
                riakIndexes.addIntSet(f.getIndexName(), (Set)ClassUtil.getFieldValue(f.getField(), obj));
                continue;
            }
            Object val = ClassUtil.getFieldValue(f.getField(), obj);
            if (val == null) continue;
            if (val instanceof String) {
                riakIndexes.add(f.getIndexName(), (String)val);
                continue;
            }
            if (!(val instanceof Integer)) continue;
            riakIndexes.add(f.getIndexName(), (Integer)val);
        }
        return riakIndexes;
    }

    public <T> void setIndexes(RiakIndexes indexes, T obj) {
        for (RiakIndexField f : this.indexFields) {
            Set<Object> val = null;
            if (Set.class.isAssignableFrom(f.getType())) {
                Type t = f.getField().getGenericType();
                if (t instanceof ParameterizedType) {
                    Class genericType = (Class)((ParameterizedType)t).getActualTypeArguments()[0];
                    if (String.class.equals((Object)genericType)) {
                        val = indexes.getBinIndex(f.getIndexName());
                    } else if (Integer.class.equals((Object)genericType)) {
                        val = indexes.getIntIndex(f.getIndexName());
                    }
                }
                if (val == null || val.isEmpty()) continue;
                ClassUtil.setFieldValue(f.getField(), obj, val);
                continue;
            }
            if (Integer.class.equals((Object)f.getType()) || Integer.TYPE.equals(f.getType())) {
                val = indexes.getIntIndex(f.getIndexName());
            } else if (String.class.equals((Object)f.getType())) {
                val = indexes.getBinIndex(f.getIndexName());
            }
            if (val == null || val.isEmpty()) continue;
            ClassUtil.setFieldValue(f.getField(), obj, val.iterator().next());
        }
    }

    public <T> Collection<RiakLink> getLinks(T obj) {
        Object o;
        ArrayList<RiakLink> links = new ArrayList<RiakLink>();
        if (this.riakLinksField != null && (o = ClassUtil.getFieldValue(this.riakLinksField, obj)) != null && o instanceof Collection) {
            links.addAll((Collection)o);
        }
        return links;
    }

    public <T> void setLinks(Collection<RiakLink> links, T obj) {
        if (this.riakLinksField != null) {
            ClassUtil.setFieldValue(this.riakLinksField, obj, links);
        }
    }
}

