/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.convert.reflect;

import com.basho.riak.client.RiakLink;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.reflect.AnnotationCache;
import com.basho.riak.client.convert.reflect.AnnotationInfo;
import com.basho.riak.client.query.indexes.RiakIndexes;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHelper {
    private static final AnnotationHelper INSTANCE = new AnnotationHelper();
    private AnnotationCache annotationCache = new AnnotationCache();

    private AnnotationHelper() {
    }

    public static AnnotationHelper getInstance() {
        return INSTANCE;
    }

    public <T> String getRiakKey(T obj) {
        String key = null;
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        if (annotationInfo.hasRiakKey()) {
            key = annotationInfo.getRiakKey(obj);
        }
        return key;
    }

    public <T> T setRiakKey(T obj, String key) {
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        if (annotationInfo.hasRiakKey()) {
            annotationInfo.setRiakKey(obj, key);
        }
        return obj;
    }

    public <T> T setRiakVClock(T obj, VClock vclock) {
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        if (annotationInfo.hasRiakVClock()) {
            annotationInfo.setRiakVClock(obj, vclock);
        }
        return obj;
    }

    public <T> VClock getRiakVClock(T obj) {
        VClock vclock = null;
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        if (annotationInfo.hasRiakVClock()) {
            vclock = annotationInfo.getRiakVClock(obj);
        }
        return vclock;
    }

    public <T> Map<String, String> getUsermetaData(T obj) {
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        return annotationInfo.getUsermetaData(obj);
    }

    public <T> T setUsermetaData(Map<String, String> usermetaData, T obj) {
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        annotationInfo.setUsermetaData(usermetaData, obj);
        return obj;
    }

    public <T> RiakIndexes getIndexes(T obj) {
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        return annotationInfo.getIndexes(obj);
    }

    public <T> T setIndexes(RiakIndexes indexes, T obj) {
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        annotationInfo.setIndexes(indexes, obj);
        return obj;
    }

    public <T> Collection<RiakLink> getLinks(T obj) {
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        return annotationInfo.getLinks(obj);
    }

    public <T> T setLinks(Collection<RiakLink> links, T obj) {
        AnnotationInfo annotationInfo = this.annotationCache.get(obj.getClass());
        annotationInfo.setLinks(links, obj);
        return obj;
    }
}

