/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.convert;

import com.basho.riak.client.convert.RiakIndex;
import com.basho.riak.client.convert.RiakKey;
import com.basho.riak.client.convert.RiakLinks;
import com.basho.riak.client.convert.RiakUsermeta;
import com.basho.riak.client.convert.RiakVClock;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializerModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiakBeanSerializerModifier
extends BeanSerializerModifier {
    private static final RiakBeanSerializerModifier INSTANCE = new RiakBeanSerializerModifier();

    private RiakBeanSerializerModifier() {
    }

    public static RiakBeanSerializerModifier getInstance() {
        return INSTANCE;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        LinkedList<BeanPropertyWriter> keptProperties = new LinkedList<BeanPropertyWriter>();
        for (BeanPropertyWriter w : beanProperties) {
            if (!this.keepProperty(w)) continue;
            keptProperties.add(w);
        }
        return keptProperties;
    }

    private boolean keepProperty(BeanPropertyWriter beanPropertyWriter) {
        RiakKey key = null;
        RiakUsermeta usermeta = null;
        RiakLinks links = null;
        RiakIndex index = null;
        RiakVClock vclock = null;
        JsonProperty jacksonJsonProperty = null;
        AnnotatedMember member = beanPropertyWriter.getMember();
        if (member instanceof AnnotatedField) {
            AnnotatedElement element = member.getAnnotated();
            key = element.getAnnotation(RiakKey.class);
            usermeta = element.getAnnotation(RiakUsermeta.class);
            links = element.getAnnotation(RiakLinks.class);
            index = element.getAnnotation(RiakIndex.class);
            vclock = element.getAnnotation(RiakVClock.class);
            jacksonJsonProperty = element.getAnnotation(JsonProperty.class);
        } else {
            Class clazz = member.getDeclaringClass();
            try {
                Field field = clazz.getDeclaredField(beanPropertyWriter.getName());
                key = field.getAnnotation(RiakKey.class);
                usermeta = field.getAnnotation(RiakUsermeta.class);
                links = field.getAnnotation(RiakLinks.class);
                index = field.getAnnotation(RiakIndex.class);
                vclock = field.getAnnotation(RiakVClock.class);
                jacksonJsonProperty = field.getAnnotation(JsonProperty.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        if (jacksonJsonProperty != null) {
            return true;
        }
        return key == null && usermeta == null && links == null && vclock == null && index == null;
    }
}

