/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.convert;

import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakLink;
import com.basho.riak.client.builders.RiakObjectBuilder;
import com.basho.riak.client.cap.VClock;
import com.basho.riak.client.convert.ConversionException;
import com.basho.riak.client.convert.Converter;
import com.basho.riak.client.convert.KeyUtil;
import com.basho.riak.client.convert.NoKeySpecifedException;
import com.basho.riak.client.convert.RiakIndexConverter;
import com.basho.riak.client.convert.RiakJacksonModule;
import com.basho.riak.client.convert.RiakLinksConverter;
import com.basho.riak.client.convert.UsermetaConverter;
import com.basho.riak.client.convert.VClockUtil;
import com.basho.riak.client.query.indexes.RiakIndexes;
import com.basho.riak.client.util.CharsetUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONConverter<T>
implements Converter<T> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Class<T> clazz;
    private final String bucket;
    private final UsermetaConverter<T> usermetaConverter;
    private final RiakIndexConverter<T> riakIndexConverter;
    private final RiakLinksConverter<T> riakLinksConverter;
    private String defaultKey;

    public JSONConverter(Class<T> clazz, String bucket) {
        this(clazz, bucket, null);
    }

    public JSONConverter(Class<T> clazz, String bucket, String defaultKey) {
        this.clazz = clazz;
        this.bucket = bucket;
        this.defaultKey = defaultKey;
        this.usermetaConverter = new UsermetaConverter();
        this.riakIndexConverter = new RiakIndexConverter();
        this.riakLinksConverter = new RiakLinksConverter();
        this.objectMapper.registerModule((Module)new RiakJacksonModule());
    }

    @Override
    public IRiakObject fromDomain(T domainObject, VClock vclock) throws ConversionException {
        try {
            String key = KeyUtil.getKey(domainObject, this.defaultKey);
            if (key == null) {
                throw new NoKeySpecifedException(domainObject);
            }
            byte[] value = this.objectMapper.writeValueAsBytes(domainObject);
            Map<String, String> usermetaData = this.usermetaConverter.getUsermetaData(domainObject);
            RiakIndexes indexes = this.riakIndexConverter.getIndexes(domainObject);
            Collection<RiakLink> links = this.riakLinksConverter.getLinks(domainObject);
            return RiakObjectBuilder.newBuilder(this.bucket, key).withValue(value).withVClock(vclock).withUsermeta(usermetaData).withIndexes(indexes).withLinks(links).withContentType("application/json; charset=UTF-8").build();
        }
        catch (JsonProcessingException e) {
            throw new ConversionException(e);
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public T toDomain(IRiakObject riakObject) throws ConversionException {
        if (riakObject == null) {
            return null;
        }
        String json = CharsetUtils.asString(riakObject.getValue(), CharsetUtils.getCharset(riakObject.getContentType()));
        try {
            Object domainObject = this.objectMapper.readValue(json, this.clazz);
            KeyUtil.setKey(domainObject, riakObject.getKey());
            VClockUtil.setVClock(domainObject, riakObject.getVClock());
            this.usermetaConverter.populateUsermeta(riakObject.getMeta(), domainObject);
            this.riakIndexConverter.populateIndexes(new RiakIndexes(riakObject.allBinIndexes(), riakObject.allIntIndexes()), domainObject);
            this.riakLinksConverter.populateLinks(riakObject.getLinks(), domainObject);
            return (T)domainObject;
        }
        catch (JsonProcessingException e) {
            throw new ConversionException(e);
        }
        catch (IOException e) {
            throw new ConversionException(e);
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

