/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client;

import com.basho.riak.client.IRiakClient;
import com.basho.riak.client.IRiakObject;
import com.basho.riak.client.RiakException;
import com.basho.riak.client.bucket.Bucket;
import com.basho.riak.client.bucket.FetchBucket;
import com.basho.riak.client.bucket.WriteBucket;
import com.basho.riak.client.cap.DefaultRetrier;
import com.basho.riak.client.cap.Retrier;
import com.basho.riak.client.query.BucketKeyMapReduce;
import com.basho.riak.client.query.BucketMapReduce;
import com.basho.riak.client.query.IndexMapReduce;
import com.basho.riak.client.query.LinkWalk;
import com.basho.riak.client.query.NodeStats;
import com.basho.riak.client.query.SearchMapReduce;
import com.basho.riak.client.raw.RawClient;
import com.basho.riak.client.raw.Transport;
import com.basho.riak.client.raw.query.indexes.IndexQuery;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultRiakClient
implements IRiakClient {
    private final RawClient rawClient;
    private final Retrier retrier;

    DefaultRiakClient(RawClient rawClient, Retrier defaultRetrier) {
        this.rawClient = rawClient;
        this.retrier = defaultRetrier;
    }

    DefaultRiakClient(RawClient rawClient) {
        this(rawClient, DefaultRetrier.attempts(3));
    }

    @Override
    public Set<String> listBuckets() throws RiakException {
        try {
            return this.rawClient.listBuckets();
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    @Override
    public WriteBucket updateBucket(Bucket b) {
        return new WriteBucket(this.rawClient, b, this.retrier);
    }

    @Override
    public FetchBucket fetchBucket(String bucketName) {
        return new FetchBucket(this.rawClient, bucketName, this.retrier);
    }

    @Override
    public WriteBucket createBucket(String bucketName) {
        return new WriteBucket(this.rawClient, bucketName, this.retrier);
    }

    @Override
    public IRiakClient setClientId(byte[] clientId) throws RiakException {
        if (clientId == null || clientId.length != 4) {
            throw new IllegalArgumentException("Client Id must be 4 bytes long");
        }
        final byte[] cloned = (byte[])clientId.clone();
        this.retrier.attempt(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultRiakClient.this.rawClient.setClientId(cloned);
                return null;
            }
        });
        return this;
    }

    @Override
    public byte[] generateAndSetClientId() throws RiakException {
        byte[] clientId = this.retrier.attempt(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return DefaultRiakClient.this.rawClient.generateAndSetClientId();
            }
        });
        return clientId;
    }

    @Override
    public byte[] getClientId() throws RiakException {
        byte[] clientId = this.retrier.attempt(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return DefaultRiakClient.this.rawClient.getClientId();
            }
        });
        return clientId;
    }

    @Override
    public BucketKeyMapReduce mapReduce() {
        return new BucketKeyMapReduce(this.rawClient);
    }

    @Override
    public BucketMapReduce mapReduce(String bucket) {
        return new BucketMapReduce(this.rawClient, bucket);
    }

    @Override
    public SearchMapReduce mapReduce(String bucket, String query) {
        return new SearchMapReduce(this.rawClient, bucket, query);
    }

    @Override
    public IndexMapReduce mapReduce(IndexQuery query) {
        return new IndexMapReduce(this.rawClient, query);
    }

    @Override
    public LinkWalk walk(IRiakObject startObject) {
        return new LinkWalk(this.rawClient, startObject);
    }

    @Override
    public void ping() throws RiakException {
        try {
            this.rawClient.ping();
        }
        catch (IOException e) {
            throw new RiakException(e);
        }
    }

    @Override
    public Transport getTransport() {
        return this.rawClient.getTransport();
    }

    @Override
    public void shutdown() {
        this.rawClient.shutdown();
    }

    @Override
    public Iterable<NodeStats> stats() throws RiakException {
        try {
            return this.rawClient.stats();
        }
        catch (Exception e) {
            throw new RiakException(e);
        }
    }
}

