/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.ListAliasesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListAliasesRequestMarshaller
implements Marshaller<Request<ListAliasesRequest>, ListAliasesRequest> {
    public Request<ListAliasesRequest> marshall(ListAliasesRequest listAliasesRequest) {
        if (listAliasesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAliasesRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ListAliases");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (listAliasesRequest.getRoutingStrategyType() != null) {
                jsonGenerator.writeFieldName("RoutingStrategyType").writeValue(listAliasesRequest.getRoutingStrategyType());
            }
            if (listAliasesRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(listAliasesRequest.getName());
            }
            if (listAliasesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listAliasesRequest.getLimit().intValue());
            }
            if (listAliasesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listAliasesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

